/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest.cloning;

import com.ibm.hwmca.base.saverest.cloning.CloningConstants;
import com.ibm.hwmca.base.saverest.cloning.CloningErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class CloningBean
extends PanelBean
implements CloningConstants,
CloningErrorIds {
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(37, "CloningBean");
    private static final String TRACE_MASKT = "XSRDCLBT";
    private static final String TRACE_MASKF = "XSRDCLBF";
    private static final String TRACE_MASKD = "XSRDCLBD";
    private transient ItemDescriptor[] m_idMachineTable;
    private transient ColumnDescriptor[] m_cdMachineTableStructure = null;
    private int[] m_iMachineTableSelection;
    private HashMap data;

    public void prepare() {
        Trace.trace(TRACE_MASKD, "setting menu");
        CloningBean cloningBean = this;
        if (cloningBean.userTaskManager.getTechnologyType().indexOf("Facade") < 0) {
            this.userTaskManager.setSelected(this.getMountPrefix() + "TaskMenu" + "." + "LocalModeItem", false);
            this.userTaskManager.setSelected(this.getMountPrefix() + "TaskMenu" + "." + "NetworkModeItem", true);
        }
    }

    public void load() {
        this.m_iMachineTableSelection = new int[0];
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        try {
            this.userTaskManager.storeAllElements();
            PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
            if (event.getActionCommand().equals("CANCEL")) {
                request.setCanceled();
            } else if (event.getActionCommand().equals("NextButton")) {
                if (this.m_iMachineTableSelection.length == 0) {
                    request.setData("event", "showMessage");
                    request.setData("showMessage", "XSRD.MAKE.MACHINE.SELECTION.MSG");
                } else {
                    LocalizableText[] selectedMachines = new LocalizableText[this.m_iMachineTableSelection.length];
                    LocalizableText[] machineNames = (LocalizableText[])this.data.get("MachineTable");
                    for (int i = 0; i < selectedMachines.length; ++i) {
                        selectedMachines[i] = machineNames[this.m_iMachineTableSelection[i]];
                    }
                    request.setData("MachineTable", selectedMachines);
                    request.setData("event", "NextButton");
                }
            } else if (event.getActionCommand().equals(this.getMountPrefix() + "TaskMenu" + "." + "LocalModeItem")) {
                request.setData("event", "LocalModeItem");
            } else if (event.getActionCommand().equals(this.getMountPrefix() + "TaskMenu" + "." + "NetworkModeItem")) {
                request.setData("event", "NetworkModeItem");
            } else if (event.getActionCommand().endsWith("ConfigureItem")) {
                request.setData("event", "ConfigureItem");
            }
            this.postTaskletRequest(request);
        }
        catch (Exception e) {
            new FrameworkLog(_logInfo, 260, e).log(FrameworkLogAttributes.INFO_LOG);
        }
    }

    public void setData(HashMap data) {
        this.data = data;
    }

    public HashMap getData() {
        return this.data;
    }

    public int getMachineTableRowCount() {
        LocalizableText[] machineNames = (LocalizableText[])this.data.get("MachineTable");
        return machineNames.length;
    }

    public ItemDescriptor[] getMachineTableRowAt(int index) {
        LocalizableText[] machineNames = (LocalizableText[])this.data.get("MachineTable");
        ItemDescriptor[] id = new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + "_machine_" + index, machineNames[index].toString())};
        return id;
    }

    public ColumnDescriptor[] getMachineTableRowStructure() {
        return this.m_cdMachineTableStructure;
    }

    public int getMachineTableRowStatus() {
        return 3;
    }

    public void setMachineTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idMachineTable = items;
    }

    public int[] getMachineTableSelection() {
        return this.m_iMachineTableSelection;
    }

    public void setMachineTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iMachineTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }
}

